#ifndef _fma_map_fabric_h_
#define _fma_map_fabric_h_

#include <time.h>
#include "fma_fabric.h"

#define FMA_MF_INITIAL_XBAR_PORT 15	/* port to use on new dumb xbar */
#define FMA_MF_DFLT_XBAR_PORTS LF_MAX_XBAR_PORTS	/* number of ports to assume */

#define FMA_MF_MAX_COMPARE_PROBES 500
#define FMA_MF_NASCENT_XBAR ((union lf_node *)1)

struct fma_map_progress {

  /* completion routine */
  void (*map_complete_rtn)(struct lf_topo_map *topo_map, int topo_map_size);
  time_t mf_start_time;			/* mapping start time */

  struct lf_nic **my_nics;		/* local NICs */

  int next_node_id;			/* next node ID to assign */
  int mf_outstanding_scouts;		/* active scouts */

  struct fma_xbar resolved_xbar_anchor;	/* list of resolved xbars */
  struct fma_xbar resolving_xbar_anchor;/* xbars with outstanding compares */
  struct fma_xbar frontier_xbar_anchor;	/* unresolved xbars */
  struct fma_xbar nascent_xbar_anchor;	/* list of totally new xbars */

  struct fma_nic  nic_anchor;		/* list of NICs */

  /* Current NIC port being mapped */
  struct lf_nic *mf_nic_being_mapped;
  int mf_port_being_mapped;

  /* Timer for scouting */
  struct fma_sync_timer *mf_scout_timer;

  int mf_scout_retries_left;		/* retry count for scouting */

  /* record node_id where xbars get merged into (forwarding address) */
  int *xbar_forward_addresses;
  int *xbar_forward_deltas;
  int xfa_size;				/* size of forwarding table */

  /* used to keep track of hosts - there is a 1:1 mapping of max mac addresses
   * to hosts in the fabric
   */
  struct lf_host **mf_hosts;		/* table of unique hosts */
  int num_hosts;			/* number of unique macs (hosts) */
  int host_table_size;			/* allocated table size */

  struct lf_topo_map *topo_map;		/* mapping results in topo_map form */
  int topo_map_size;
};

struct fma_mf_info {

  /* "closed" means this port should not be considered when performing
   * xbar compares
   */
  int mf_closed;		
};

/*
 * prototypes
 */
void fma_mf_got_compare_resp(struct fma_nic_info *nip, int port,
    struct fma_xbar_compare_pkt *pkt);
void fma_mf_got_nic_scout_resp(struct myri_nic_scout_reply *pkt, int len);
void fma_mf_got_xbar_resp(struct fma_nic_info *nip, int port,
        struct fma_xbar_scout_pkt *pkt);
void fma_mf_got_tagged_xbar_resp(struct fma_nic_info *nip, int port,
        struct fma_xbar_scout_pkt *pkt);
void fma_mf_free_nic(struct lf_nic *nicp);

#endif /* _fma_map_fabric_h_ */
